/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.illusivesoulworks.constructsarmory.ConstructsArmoryMod;
import com.james.tinkerscalibration.Utils;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ArmorImpregnableModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> IMPREGNABLE = ConstructsArmoryMod.createKey((String)"impregnable");

    public ArmorImpregnableModifier() {
        super(IMPREGNABLE);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorImpregnableModifier::onHurt);
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntityLiving();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(IMPREGNABLE, (Object)0);
            if (level > 0 && attacker != null && event.getAmount() != 0.0f) {
                int effectLevel = Math.min(7, ((TinkerEffect)Utils.impregnableEffect.get()).getLevel(living) + 1);
                ((TinkerEffect)Utils.impregnableEffect.get()).apply(living, 100, effectLevel, true);
            }
        });
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        float bonus = ArmorImpregnableModifier.getBonus(holder, Utils.impregnableEffect, level, 6.0f);
        int off = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(RANDOM.nextFloat() >= 1.0f / bonus)) continue;
            ++off;
        }
        return amount - off;
    }
}

